floor_texture = register_texture("textures/floor.png")
wall_texture = register_texture("textures/concrete.png")

if not floor_texture or floor_texture==0 then floor_texture = register_builtin_texture("floor") end
if not wall_texture or wall_texture==0 then wall_texture = register_builtin_texture("wall") end

-- floor
register_floor({letter = ".",
	texture_id = floor_texture
})

-- wall
register_entity({letters = "#",
	texture_id = wall_texture,
	draw_above = true,
	ghost_obstacle = true
})

-- spawner
register_entity({letters = "sST",
	texture_id = register_builtin_texture("spawner"),
	draw_above = false,
	ghost_obstacle = false,
	on_ghost_respawn = function(x, y)
		if map_get(x, y) ~= "s" then return false end
		map_put(x, y, "S")
		return true
	end
})

-- food
register_entity({letters = "fF",
	texture_id = register_builtin_texture("food"),
	draw_above = false,
	ghost_obstacle = false
})

-- buff
register_entity({letters = "bB",
	texture_id = register_builtin_texture("buff"),
	draw_above = false,
	ghost_obstacle = false
})

-- ghost
register_entity({letters = "GSFB",
	texture_id = register_texture("textures/ghost.png"),
	draw_above = true,
	ghost_obstacle = false
})

print(dump(registered_entities))